/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.custom_blocks;

import com.mojang.brigadier.StringReader;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockImplementation;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.CustomBlockStateImplementation;
import com.moulberry.axiom.custom_blocks.update.AxisCustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.CustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.FacingClickedCustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.FacingClickedOppositeCustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.FacingCustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.FacingOppositeCustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.HalfCustomBlockUpdater;
import com.moulberry.axiom.custom_blocks.update.WaterloggedCustomBlockUpdater;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ServerCustomBlocks {
    public static final Map<class_2960, CustomBlock> customBlockMap = new HashMap<class_2960, CustomBlock>();
    private static final Map<class_2680, CustomBlockState> vanillaStateToCustomBlockState = new HashMap<class_2680, CustomBlockState>();
    private static final Map<class_2960, CustomBlockUpdater> updaterMap = new HashMap<class_2960, CustomBlockUpdater>();

    public static void clearRegisteredCustomBlocks() {
        customBlockMap.clear();
        vanillaStateToCustomBlockState.clear();
    }

    public static void registerCustomBlock(class_2960 resourceLocation, String translationKey, class_1799 pickBlockStack, boolean doNormalInteractions, List<class_2769<?>> properties, List<class_2960> updaters, List<class_2680> vanillaStates) {
        ArrayList<CustomBlockUpdater> blockUpdaters = new ArrayList<CustomBlockUpdater>(updaters.size());
        for (class_2960 updater : updaters) {
            CustomBlockUpdater customBlockUpdater = updaterMap.get(updater);
            if (customBlockUpdater == null) {
                throw new RuntimeException(String.valueOf(resourceLocation) + " - unknown custom block updater: " + String.valueOf(updater));
            }
            blockUpdaters.add(customBlockUpdater);
        }
        if (customBlockMap.containsKey(resourceLocation)) {
            throw new RuntimeException(String.valueOf(resourceLocation) + " - duplicate custom block registered: " + String.valueOf(resourceLocation));
        }
        ItemStackDataHelper.setCustomBlockPlacer(pickBlockStack, resourceLocation.toString());
        CustomBlockImplementation customBlock = new CustomBlockImplementation(resourceLocation, translationKey, pickBlockStack, doNormalInteractions, properties, blockUpdaters, vanillaStates);
        customBlockMap.put(resourceLocation, customBlock);
        for (CustomBlockState possibleCustomState : customBlock.getPossibleCustomStates()) {
            class_2680 vanillaState = possibleCustomState.getVanillaState();
            if (vanillaStateToCustomBlockState.containsKey(vanillaState)) {
                throw new RuntimeException(String.valueOf(resourceLocation) + " - duplicate vanilla state registered: " + vanillaState.toString());
            }
            vanillaStateToCustomBlockState.put(vanillaState, possibleCustomState);
        }
    }

    public static void update() {
        EditorUI.getBlockList().markNeedsReload();
        Configuration.internal.rootEditorPalette.reload();
    }

    @Nullable
    public static CustomBlock getCustomBlock(class_2960 resourceLocation) {
        return customBlockMap.get(resourceLocation);
    }

    @Nullable
    public static CustomBlockState getCustomStateFor(class_2680 blockState) {
        return vanillaStateToCustomBlockState.get(blockState);
    }

    public static void registerUpdater(class_2960 resourceLocation, CustomBlockUpdater customBlockUpdater) {
        updaterMap.put(resourceLocation, customBlockUpdater);
    }

    public static String serialize(CustomBlockState customBlockState) {
        if (customBlockState instanceof class_2680) {
            class_2680 blockState = (class_2680)customBlockState;
            return class_2259.method_9685((class_2680)blockState);
        }
        if (customBlockState instanceof CustomBlockStateImplementation) {
            CustomBlockStateImplementation state = (CustomBlockStateImplementation)customBlockState;
            StringBuilder stringBuilder = new StringBuilder(state.getCustomBlock().getResourceLocation().toString());
            if (!state.method_28501().isEmpty()) {
                stringBuilder.append('[');
                boolean addComma = false;
                for (Map.Entry entry : state.method_11656().entrySet()) {
                    if (addComma) {
                        stringBuilder.append(',');
                    }
                    ServerCustomBlocks.appendProperty(stringBuilder, (class_2769)entry.getKey(), (Comparable)entry.getValue());
                    addComma = true;
                }
                stringBuilder.append(']');
            }
            return stringBuilder.toString();
        }
        throw new FaultyImplementationError();
    }

    private static <T extends Comparable<T>> void appendProperty(StringBuilder stringBuilder, class_2769<T> property, Comparable<?> comparable) {
        stringBuilder.append(property.method_11899());
        stringBuilder.append('=');
        stringBuilder.append(property.method_11901(comparable));
    }

    public static CustomBlockState deserialize(String input) {
        return ServerCustomBlocks.deserialize(input, null);
    }

    public static CustomBlockState deserialize(String input, Set<String> nonDefaultProperties) {
        try {
            class_2259.class_7211 result = class_2259.method_41957((class_7225)class_7923.field_41175.method_46771(), (String)input, (boolean)false);
            if (nonDefaultProperties != null) {
                for (class_2769 property : result.comp_623().keySet()) {
                    nonDefaultProperties.add(property.method_11899());
                }
            }
            return (CustomBlockState)result.comp_622();
        }
        catch (Exception result) {
            try {
                StringReader reader = new StringReader(input);
                class_2960 resourceLocation = class_2960.method_12835((StringReader)reader);
                CustomBlock customBlock = ServerCustomBlocks.getCustomBlock(resourceLocation);
                if (customBlock == null) {
                    return null;
                }
                CustomBlockImplementation customBlockImplementation = (CustomBlockImplementation)customBlock;
                class_2689<CustomBlock, CustomBlockStateImplementation> definition = customBlockImplementation.getStateDefinition();
                CustomBlockState customBlockState = customBlockImplementation.defaultCustomState();
                if (reader.canRead()) {
                    if (reader.peek() == '[') {
                        reader.skip();
                        reader.skipWhitespace();
                        while (reader.canRead() && reader.peek() != ']') {
                            reader.skipWhitespace();
                            String string = reader.readString();
                            class_2769 property = definition.method_11663(string);
                            if (property == null) {
                                return null;
                            }
                            reader.skipWhitespace();
                            if (!reader.canRead() || reader.peek() != '=') {
                                return null;
                            }
                            reader.skip();
                            reader.skipWhitespace();
                            if (nonDefaultProperties != null) {
                                nonDefaultProperties.add(property.method_11899());
                            }
                            if ((customBlockState = ServerCustomBlocks.setValue(customBlockState, property, reader.readString())) == null) {
                                return null;
                            }
                            reader.skipWhitespace();
                            if (!reader.canRead()) continue;
                            if (reader.peek() == ',') {
                                reader.skip();
                                continue;
                            }
                            if (reader.peek() != ']') {
                                return null;
                            }
                            break;
                        }
                    } else {
                        return null;
                    }
                }
                return customBlockState;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static <T extends Comparable<T>> CustomBlockState setValue(CustomBlockState customBlockState, class_2769<T> property, String string) {
        Optional optional = property.method_11900(string);
        if (optional.isEmpty()) {
            return null;
        }
        return customBlockState.setPropertyUnsafe(property, (Comparable)optional.get());
    }

    private static void registerDefaultUpdaters() {
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:axis"), new AxisCustomBlockUpdater());
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:facing"), new FacingCustomBlockUpdater());
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:facing_opposite"), new FacingOppositeCustomBlockUpdater());
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:facing_clicked"), new FacingClickedCustomBlockUpdater());
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:facing_clicked_opposite"), new FacingClickedOppositeCustomBlockUpdater());
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:waterlogged"), new WaterloggedCustomBlockUpdater());
        ServerCustomBlocks.registerUpdater(new class_2960("axiom:half"), new HalfCustomBlockUpdater());
    }

    static {
        ServerCustomBlocks.registerDefaultUpdaters();
    }
}

